//
//  BIDocument+ObjectCreationHandler.h
//  BIViews
//
//  Created by Eric Hochmeister on 05/01/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "BIDocument.h"

@class ABPerson, BIUser, BIClient, BIProject;
@class BIEstimateSlip;
@class BITimeSlip;

@interface BIDocument (ObjectCreationHandler)

- (BIUser*)createUser;
- (BIClient*)createClientWithABPerson:(ABPerson*)anABPerson;

- (BIProject*)createProjectForClient:(BIClient*)aClient;

- (BITimeSlip*)createTimedTimeSlipWithDefaultValues;

- (BIEstimateSlip*)createEstimateSlipWithDefaultValues;

- (BITimeSlip*)createRealTimeSlipFromTimeSlip:(BIEstimateSlip*)aTimeSlip;

- (BIPayment*)createNewPaymentNotInObjectContext;

@end
